<?php
// Arquivo para testar a conexão com o banco de dados

// Incluir o arquivo de inicialização
require_once '../app/init.php';

// Tentar conexão com o banco de dados
try {
    $db = db_connect();
    echo '<h1>Conexão com o banco de dados realizada com sucesso!</h1>';
    echo '<p>O banco de dados está funcionando corretamente.</p>';
    
    // Exibir informações do PHP e do banco de dados
    echo '<h2>Informações do Sistema:</h2>';
    echo '<ul>';
    echo '<li>Versão do PHP: ' . phpversion() . '</li>';
    echo '<li>Servidor: ' . $_SERVER['SERVER_SOFTWARE'] . '</li>';
    echo '<li>Banco de dados: MySQL</li>';
    echo '</ul>';
    
    echo '<p><a href="index.php">Voltar para a página inicial</a></p>';
} catch (PDOException $e) {
    echo '<h1>Erro na conexão com o banco de dados</h1>';
    echo '<p>Ocorreu um erro ao tentar conectar ao banco de dados:</p>';
    echo '<pre>' . $e->getMessage() . '</pre>';
    
    echo '<h2>Verifique os seguintes itens:</h2>';
    echo '<ul>';
    echo '<li>O serviço MySQL está iniciado?</li>';
    echo '<li>As configurações em app/config/database.php estão corretas?</li>';
    echo '<li>O banco de dados especificado existe?</li>';
    echo '<li>O usuário tem permissão para acessar o banco de dados?</li>';
    echo '</ul>';
}
?> 