<?php
/**
 * Arquivo principal de entrada da aplicação
 */

// Carregar configurações
require_once __DIR__ . '/../app/config/config.php';

// Roteamento simples
$path = $_SERVER['REQUEST_URI'];

// Remover parâmetros da URL
if (($pos = strpos($path, '?')) !== false) {
    $path = substr($path, 0, $pos);
}

// Remover base path
$base_path = parse_url(URL, PHP_URL_PATH);
if ($base_path && strpos($path, $base_path) === 0) {
    $path = substr($path, strlen($base_path));
}

// Garantir que o caminho comece com /
$path = '/' . ltrim($path, '/');

// Roteamento
switch ($path) {
    case '/':
    case '/index.php':
        if (is_logged_in()) {
            redirect('/dashboard.php');
        } else {
            include APP_PATH . '/views/auth/login.php';
        }
        break;
        
    case '/login':
    case '/login.php':
        include APP_PATH . '/views/auth/login.php';
        break;
        
    case '/logout':
    case '/logout.php':
        session_unset();
        session_destroy();
        redirect('/login.php');
        break;
        
    case '/dashboard':
    case '/dashboard.php':
        require_login();
        include APP_PATH . '/views/dashboard.php';
        break;
        
    // Usuários
    case '/usuarios':
    case '/usuarios.php':
        require_gestor();
        include APP_PATH . '/views/admin/usuarios/index.php';
        break;
        
    case '/usuarios/novo':
    case '/usuarios/novo.php':
        require_gestor();
        include APP_PATH . '/views/admin/usuarios/form.php';
        break;
        
    case '/usuarios/editar':
    case '/usuarios/editar.php':
        require_gestor();
        include APP_PATH . '/views/admin/usuarios/form.php';
        break;
        
    // Franquias
    case '/franquias':
    case '/franquias.php':
        require_admin();
        include APP_PATH . '/views/admin/franquias/index.php';
        break;
        
    case '/franquias/nova':
    case '/franquias/nova.php':
        require_admin();
        include APP_PATH . '/views/admin/franquias/form.php';
        break;
        
    case '/franquias/editar':
    case '/franquias/editar.php':
        require_admin();
        include APP_PATH . '/views/admin/franquias/form.php';
        break;
        
    // Arquivos
    case '/arquivos':
    case '/arquivos.php':
        require_login();
        include APP_PATH . '/views/franqueado/arquivos/index.php';
        break;
        
    case '/arquivos/upload':
    case '/arquivos/upload.php':
        require_login();
        include APP_PATH . '/views/franqueado/arquivos/upload.php';
        break;
        
    case '/arquivos/visualizar':
    case '/arquivos/visualizar.php':
        require_login();
        include APP_PATH . '/views/franqueado/arquivos/visualizar.php';
        break;
        
    // Pastas
    case '/pastas':
    case '/pastas.php':
        require_login();
        include APP_PATH . '/views/franqueado/pastas/index.php';
        break;
        
    case '/pastas/nova':
    case '/pastas/nova.php':
        require_login();
        include APP_PATH . '/views/franqueado/pastas/form.php';
        break;
        
    case '/pastas/editar':
    case '/pastas/editar.php':
        require_login();
        include APP_PATH . '/views/franqueado/pastas/form.php';
        break;
        
    // Notificações
    case '/notificacoes':
    case '/notificacoes.php':
        require_login();
        include APP_PATH . '/views/franqueado/notificacoes/index.php';
        break;
        
    case '/notificacoes/nova':
    case '/notificacoes/nova.php':
        require_gestor();
        include APP_PATH . '/views/franqueado/notificacoes/form.php';
        break;
        
    // Eventos
    case '/eventos':
    case '/eventos.php':
        require_login();
        include APP_PATH . '/views/franqueado/eventos/index.php';
        break;
        
    case '/eventos/novo':
    case '/eventos/novo.php':
        require_login();
        include APP_PATH . '/views/franqueado/eventos/form.php';
        break;
        
    case '/eventos/editar':
    case '/eventos/editar.php':
        require_login();
        include APP_PATH . '/views/franqueado/eventos/form.php';
        break;
        
    case '/calendario':
    case '/calendario.php':
        require_login();
        include APP_PATH . '/views/franqueado/calendario/index.php';
        break;
        
    // API para AJAX
    case '/api/notificacoes/contador':
        require_login();
        include APP_PATH . '/controllers/api/notificacoes_contador.php';
        break;
        
    case '/api/eventos/calendario':
        require_login();
        include APP_PATH . '/controllers/api/eventos_calendario.php';
        break;
        
    case '/api/arquivos/upload':
        require_login();
        include APP_PATH . '/controllers/api/arquivos_upload.php';
        break;
        
    // Perfil do usuário
    case '/perfil':
    case '/perfil.php':
        require_login();
        include APP_PATH . '/views/auth/perfil.php';
        break;
        
    // Páginas de erro
    case '/404':
    case '/404.php':
        http_response_code(404);
        include APP_PATH . '/views/errors/404.php';
        break;
        
    case '/403':
    case '/403.php':
        http_response_code(403);
        include APP_PATH . '/views/errors/403.php';
        break;
        
    case '/500':
    case '/500.php':
        http_response_code(500);
        include APP_PATH . '/views/errors/500.php';
        break;
        
    default:
        // Verificar se o caminho é para um arquivo estático em public
        $file_path = __DIR__ . $path;
        if (file_exists($file_path) && is_file($file_path)) {
            // Definir tipo MIME adequado
            $extension = pathinfo($file_path, PATHINFO_EXTENSION);
            switch ($extension) {
                case 'css':
                    header('Content-Type: text/css');
                    break;
                case 'js':
                    header('Content-Type: application/javascript');
                    break;
                case 'jpg':
                case 'jpeg':
                    header('Content-Type: image/jpeg');
                    break;
                case 'png':
                    header('Content-Type: image/png');
                    break;
                case 'gif':
                    header('Content-Type: image/gif');
                    break;
                case 'svg':
                    header('Content-Type: image/svg+xml');
                    break;
                case 'pdf':
                    header('Content-Type: application/pdf');
                    break;
                // Adicione outros tipos conforme necessário
            }
            
            // Enviar arquivo
            readfile($file_path);
            exit;
        }
        
        // Página não encontrada
        http_response_code(404);
        include APP_PATH . '/views/errors/404.php';
        break;
} 