<?php
/**
 * Arquivo principal para gerenciamento de arquivos
 */

// Incluir o arquivo de inicialização
require_once '../app/init.php';

// Verificar se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    redirect('/login.php');
}

// Instanciar os modelos necessários
$arquivo_model = new Arquivo();
$usuario_model = new Usuario();
$franquia_model = new Franquia();

$user_id = $_SESSION['user_id'];
$user_type = $_SESSION['user_type'];

// Processar ações POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Editar informações do arquivo
    if (isset($_POST['action']) && $_POST['action'] === 'editar_arquivo') {
        $arquivo_id = (int)$_POST['arquivo_id'];
        $nome = trim($_POST['nome']);
        $visibilidade = $_POST['visibilidade'];
        $franquia_id = !empty($_POST['franquia_id']) ? (int)$_POST['franquia_id'] : null;
        
        // Verificar se o arquivo existe e pertence ao usuário
        $arquivo = $arquivo_model->getById($arquivo_id);
        
        if ($arquivo && ($arquivo['usuario_id'] == $user_id || is_admin())) {
            // Atualizar informações
            $dados = [
                'nome' => $nome,
                'visibilidade' => $visibilidade,
                'franquia_id' => $franquia_id
            ];
            
            $arquivo_model->update($arquivo_id, $dados);
            set_flash_message('success', 'Informações do arquivo atualizadas com sucesso.');
            
            // Redirecionar para a página de visualização
            redirect('/arquivos.php?view=visualizar&id=' . $arquivo_id);
        } else {
            set_flash_message('danger', 'Você não tem permissão para editar este arquivo.');
            redirect('/arquivos.php');
        }
    }
}

// Processar ações de exclusão
if (isset($_GET['excluir_arquivo']) && !empty($_GET['excluir_arquivo'])) {
    $arquivo_id = (int)$_GET['excluir_arquivo'];
    $arquivo = $arquivo_model->getById($arquivo_id);
    
    if ($arquivo && ($arquivo['usuario_id'] == $user_id || is_admin())) {
        // Caminho físico do arquivo
        $caminho_fisico = UPLOAD_PATH . '/' . $arquivo['caminho'];
        
        // Tentar excluir o arquivo do sistema de arquivos
        if (file_exists($caminho_fisico) && is_file($caminho_fisico)) {
            unlink($caminho_fisico);
        }
        
        // Excluir do banco de dados
        $arquivo_model->delete($arquivo_id);
        set_flash_message('success', 'Arquivo excluído com sucesso.');
    } else {
        set_flash_message('danger', 'Você não tem permissão para excluir este arquivo.');
    }
    
    redirect('/arquivos.php');
}

// Obter franquias do usuário
$franquias_usuario = $usuario_model->getFranquias($user_id);

// Determinar qual view exibir
$view = isset($_GET['view']) ? $_GET['view'] : 'listar';

switch ($view) {
    case 'visualizar':
        // A lógica de visualização está no arquivo visualizar.php
        $pagina = 'franqueado/arquivos/visualizar.php';
        break;
        
    case 'upload':
        // A lógica de upload está no arquivo upload.php
        $pagina = 'franqueado/arquivos/upload.php';
        break;
        
    case 'listar':
    default:
        // Parâmetros de filtro
        $pasta_atual = isset($_GET['pasta']) ? $_GET['pasta'] : null;
        $franquia_id = isset($_GET['franquia']) ? (int)$_GET['franquia'] : null;
        
        // Obter arquivos do usuário
        $arquivos = [];
        
        if ($franquia_id) {
            // Verificar se o usuário tem acesso à franquia
            $franquia_permitida = false;
            foreach ($franquias_usuario as $fr) {
                if ($fr['id'] == $franquia_id) {
                    $franquia_permitida = true;
                    break;
                }
            }
            
            if ($franquia_permitida || is_admin()) {
                // Arquivos da franquia
                $arquivos = $arquivo_model->getByFranquia($franquia_id, $pasta_atual);
                $franquia_info = $franquia_model->getById($franquia_id);
                $titulo_listagem = 'Arquivos da Franquia: ' . htmlspecialchars($franquia_info['nome']);
            } else {
                set_flash_message('danger', 'Você não tem acesso a esta franquia.');
                redirect('/arquivos.php');
            }
        } else {
            // Arquivos pessoais do usuário
            $arquivos = $arquivo_model->getByUsuario($user_id, $pasta_atual);
            $titulo_listagem = 'Meus Arquivos';
        }
        
        $pagina = 'franqueado/arquivos/listar.php';
        break;
}

// Carregar a view apropriada
include_once APP_PATH . '/views/' . $pagina;
?> 