<?php
/**
 * Script para importar o banco de dados
 */

// Configurações do banco de dados
$config = [
    'host' => 'localhost',
    'username' => 'root',
    'password' => '',
    'database' => 'sistema_franqueados'
];

// Conectar ao MySQL (sem selecionar um banco de dados específico)
try {
    $pdo = new PDO(
        "mysql:host={$config['host']};charset=utf8mb4",
        $config['username'],
        $config['password'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
    
    echo "<h1>Tentando criar e configurar o banco de dados</h1>";
    
    // Criar o banco de dados se não existir
    $pdo->exec("CREATE DATABASE IF NOT EXISTS {$config['database']} CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "<p>✅ Banco de dados {$config['database']} criado ou já existente</p>";
    
    // Selecionar o banco de dados
    $pdo->exec("USE {$config['database']}");
    echo "<p>✅ Banco de dados {$config['database']} selecionado</p>";
    
    // Ler o arquivo SQL
    $sql_file = 'criar_banco.sql';
    if (!file_exists($sql_file)) {
        throw new Exception("Arquivo $sql_file não encontrado!");
    }
    
    $sql = file_get_contents($sql_file);
    
    // Dividir o SQL em consultas individuais
    $queries = explode(';', $sql);
    
    echo "<h2>Executando consultas SQL:</h2>";
    echo "<ul>";
    
    // Executar cada consulta
    foreach ($queries as $query) {
        $query = trim($query);
        if (empty($query)) continue;
        
        try {
            $pdo->exec($query);
            $command = strtok(trim($query), ' ');
            echo "<li>✅ Consulta executada: " . htmlspecialchars($command) . "...</li>";
        } catch (PDOException $e) {
            echo "<li>❌ Erro ao executar consulta: " . htmlspecialchars(substr($query, 0, 50)) . "... - " . $e->getMessage() . "</li>";
        }
    }
    
    echo "</ul>";
    
    echo "<h2>Processo concluído!</h2>";
    echo "<p>O banco de dados foi criado e configurado com sucesso.</p>";
    echo "<p><a href='public/index.php' class='btn btn-primary'>Acessar o Sistema</a> (usuário: admin@sistema.com / senha: admin123)</p>";
    
} catch (PDOException $e) {
    echo "<h1>Erro de conexão com o banco de dados</h1>";
    echo "<p>" . $e->getMessage() . "</p>";
} catch (Exception $e) {
    echo "<h1>Erro</h1>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>

<style>
    body {
        font-family: Arial, sans-serif;
        line-height: 1.6;
        margin: 20px;
    }
    h1, h2 {
        color: #333;
    }
    ul {
        background-color: #f5f5f5;
        padding: 15px 25px;
        border-radius: 5px;
    }
    li {
        margin-bottom: 8px;
    }
    .btn {
        display: inline-block;
        background-color: #0275d8;
        color: white;
        padding: 10px 15px;
        text-decoration: none;
        border-radius: 4px;
        margin-top: 10px;
    }
    .btn:hover {
        background-color: #025aa5;
    }
</style> 