<?php
/**
 * Layout padrão do sistema
 */

// Verificar se o usuário está logado
require_login();

// Obter informações do usuário logado
$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];
$user_email = $_SESSION['user_email'];
$user_type = $_SESSION['user_type'];

// Carregar modelo de notificações para exibir contador
$notificacao = new Notificacao();
$qtd_notificacoes = $notificacao->contarNaoLidas($user_id);

// Carregar modelo de eventos para exibir próximos eventos
$evento = new Evento();
$proximos_eventos = $evento->getProximos(3, $user_id);

// Flash message
$flash = get_flash_message();

// Definir título da página se não existir
if (!isset($titulo_pagina)) {
    $titulo_pagina = 'Sistema de Franqueados';
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo_pagina ? $titulo_pagina . ' | ' : ''; ?>Sistema de Franqueados</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    
    <!-- Custom styles -->
    <style>
        body {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .sidebar {
            width: 250px;
            min-height: 100vh;
            background-color: #212529;
            color: #fff;
            transition: all 0.3s;
        }
        .sidebar.collapsed {
            margin-left: -250px;
        }
        .content {
            flex: 1;
            transition: all 0.3s;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.7);
            padding: 0.8rem 1rem;
            border-radius: 0;
        }
        .sidebar .nav-link:hover {
            color: #fff;
            background-color: rgba(255, 255, 255, 0.1);
        }
        .sidebar .nav-link.active {
            color: #fff;
            background-color: #0d6efd;
        }
        .sidebar .nav-link i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        .sidebar-heading {
            padding: 0.75rem 1rem;
            font-size: 0.8rem;
            text-transform: uppercase;
            color: rgba(255, 255, 255, 0.5);
            font-weight: bold;
        }
        .dropdown-toggle::after {
            margin-left: auto;
        }
        .dropdown-menu {
            background-color: #343a40;
            border: none;
        }
        .dropdown-item {
            color: rgba(255, 255, 255, 0.7);
        }
        .dropdown-item:hover {
            color: #fff;
            background-color: rgba(255, 255, 255, 0.1);
        }
        .dropdown-item.active, .dropdown-item:active {
            background-color: #0d6efd;
        }
        .notification-badge {
            position: absolute;
            top: 5px;
            right: 8px;
            font-size: 0.7rem;
        }
        .navbar {
            padding: 0.4rem 1rem;
        }
        .nav-item-header {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.5);
            padding: 0.5rem 1rem;
            margin-top: 1rem;
            text-transform: uppercase;
            font-weight: bold;
        }
        .navbar-toggler {
            padding: 0.25rem 0.5rem;
            font-size: 1rem;
        }
        .dropdown-header {
            font-size: 0.8rem;
            font-weight: bold;
            color: rgba(255, 255, 255, 0.5);
        }
        .bg-navbar-dark {
            background-color: #282f35;
        }
        .nav-sub-item {
            padding-left: 3rem !important;
            font-size: 0.9rem;
        }
        .topbar-divider {
            width: 0;
            border-right: 1px solid #e3e6f0;
            height: 2rem;
            margin: auto 1rem;
        }
        .user-info {
            max-width: 12rem;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
        .page-link {
            color: #0d6efd;
        }
        .card-header {
            padding: 0.75rem 1.25rem;
            background-color: #f8f9fa;
            border-bottom: 1px solid #e3e6f0;
        }
        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
            }
            .sidebar.show {
                margin-left: 0;
            }
            .content {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="d-flex">
        <!-- Sidebar -->
        <div class="sidebar d-none d-md-block">
            <div class="sidebar-brand d-flex align-items-center justify-content-center p-3">
                <div class="sidebar-brand-icon">
                    <i class="fas fa-store fa-2x"></i>
                </div>
                <div class="sidebar-brand-text mx-3">SISTEMA</div>
            </div>
            
            <hr class="sidebar-divider my-0">
            
            <!-- Nav Items -->
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>" href="/dashboard.php">
                        <i class="fas fa-fw fa-tachometer-alt"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
                
                <div class="nav-item-header">Arquivos</div>
                
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'arquivos.php' && (!isset($_GET['view']) || $_GET['view'] == 'listar') ? 'active' : ''; ?>" href="/arquivos.php">
                        <i class="fas fa-fw fa-folder"></i>
                        <span>Meus Arquivos</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'arquivos.php' && isset($_GET['view']) && $_GET['view'] == 'upload' ? 'active' : ''; ?>" href="/arquivos.php?view=upload">
                        <i class="fas fa-fw fa-upload"></i>
                        <span>Upload de Arquivos</span>
                    </a>
                </li>
                
                <div class="nav-item-header">Franquias</div>
                
                <?php 
                // Obter franquias do usuário para o menu
                $usuario_obj = new Usuario();
                $franquias_menu = $usuario_obj->getFranquias($_SESSION['user_id']);
                
                foreach ($franquias_menu as $franquia): 
                ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo isset($_GET['franquia']) && $_GET['franquia'] == $franquia['id'] ? 'active' : ''; ?>" href="/arquivos.php?franquia=<?php echo $franquia['id']; ?>">
                        <i class="fas fa-fw fa-store"></i>
                        <span><?php echo htmlspecialchars($franquia['nome']); ?></span>
                    </a>
                </li>
                <?php endforeach; ?>
                
                <div class="nav-item-header">Outras Opções</div>
                
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'notificacoes.php' ? 'active' : ''; ?>" href="/notificacoes.php">
                        <i class="fas fa-fw fa-bell"></i>
                        <span>Notificações</span>
                        <?php 
                        // Obter contagem de notificações não lidas
                        $notificacao_obj = new Notificacao();
                        $count_nao_lidas = $notificacao_obj->contarNaoLidas($_SESSION['user_id']);
                        if ($count_nao_lidas > 0):
                        ?>
                        <span class="badge rounded-pill bg-danger notification-badge"><?php echo $count_nao_lidas; ?></span>
                        <?php endif; ?>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'calendario.php' ? 'active' : ''; ?>" href="/calendario.php">
                        <i class="fas fa-fw fa-calendar"></i>
                        <span>Calendário</span>
                    </a>
                </li>
                
                <?php if (is_gestor()): ?>
                <div class="nav-item-header">Administração</div>
                
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'usuarios.php' ? 'active' : ''; ?>" href="/usuarios.php">
                        <i class="fas fa-fw fa-users"></i>
                        <span>Usuários</span>
                    </a>
                </li>
                <?php endif; ?>
                
                <?php if (is_admin()): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'franquias.php' ? 'active' : ''; ?>" href="/franquias.php">
                        <i class="fas fa-fw fa-store"></i>
                        <span>Franquias</span>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
            
            <hr class="sidebar-divider d-none d-md-block">
            
            <!-- Sidebar Toggler -->
            <div class="text-center">
                <button class="btn btn-link d-md-none rounded-circle" id="sidebarToggle">
                    <i class="fas fa-angle-right"></i>
                </button>
            </div>
        </div>
        
        <!-- Content Wrapper -->
        <div class="content w-100">
            <!-- Topbar -->
            <nav class="navbar navbar-expand navbar-dark bg-navbar-dark">
                <!-- Sidebar Toggle (Topbar) -->
                <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3 text-white">
                    <i class="fas fa-bars"></i>
                </button>
                
                <!-- Page Title -->
                <h5 class="text-white mb-0"><?php echo $titulo_pagina; ?></h5>
                
                <!-- Topbar Navbar -->
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item dropdown no-arrow">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <span class="d-none d-md-inline me-2 text-white small user-info">
                                <?php echo htmlspecialchars($_SESSION['user_name']); ?>
                                <small class="text-muted">(<?php echo ucfirst($_SESSION['user_type']); ?>)</small>
                            </span>
                            <i class="fas fa-user-circle fa-fw text-white"></i>
                        </a>
                        <!-- Dropdown - User Information -->
                        <div class="dropdown-menu dropdown-menu-end shadow animated--grow-in"
                            aria-labelledby="userDropdown">
                            <a class="dropdown-item" href="/perfil.php">
                                <i class="fas fa-user fa-sm fa-fw me-2 text-muted"></i>
                                Perfil
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="/logout.php">
                                <i class="fas fa-sign-out-alt fa-sm fa-fw me-2 text-muted"></i>
                                Sair
                            </a>
                        </div>
                    </li>
                </ul>
            </nav>
            
            <!-- Main Content -->
            <main class="px-4 py-3">
                <?php
                // Exibir mensagem flash, se existir
                if ($flash):
                ?>
                <div class="alert alert-<?php echo $flash['type']; ?> alert-dismissible fade show" role="alert">
                    <?php echo $flash['message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Fechar"></button>
                </div>
                <?php endif; ?>
                
                <!-- Page Content -->
                <?php echo $conteudo; ?>
            </main>
            
            <!-- Footer -->
            <footer class="sticky-footer bg-light p-3 mt-auto">
                <div class="container-fluid">
                    <div class="copyright text-center small">
                        &copy; <?php echo date('Y'); ?> Sistema de Franqueados
                    </div>
                </div>
            </footer>
        </div>
    </div>
    
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Toggle Sidebar
        document.addEventListener('DOMContentLoaded', function() {
            // Check window width
            function checkWidth() {
                if (window.innerWidth < 768) {
                    document.querySelector('.sidebar').classList.remove('d-none');
                    document.querySelector('.sidebar').classList.remove('d-md-block');
                    document.querySelector('.sidebar').classList.add('d-none');
                } else {
                    document.querySelector('.sidebar').classList.remove('d-none');
                    document.querySelector('.sidebar').classList.add('d-md-block');
                }
            }
            
            // Initial check
            checkWidth();
            
            // Listen for window resize
            window.addEventListener('resize', checkWidth);
            
            // Toggle button for mobile
            document.getElementById('sidebarToggleTop').addEventListener('click', function() {
                document.querySelector('.sidebar').classList.toggle('d-none');
            });
        });
    </script>
</body>
</html> 