<?php
/**
 * Página de visualização de arquivo
 */

$titulo_pagina = 'Visualizar Arquivo';

// Obter informações do usuário
$user_id = $_SESSION['user_id'];
$user_type = $_SESSION['user_type'];

// Verificar se o ID do arquivo foi fornecido
if (!isset($_GET['id']) || empty($_GET['id'])) {
    set_flash_message('danger', 'Arquivo não especificado.');
    redirect('/arquivos.php');
}

$arquivo_id = (int)$_GET['id'];

// Carregar modelos
$arquivo_model = new Arquivo();
$usuario = new Usuario();
$franquia = new Franquia();

// Obter informações do arquivo
$arquivo = $arquivo_model->getById($arquivo_id);

// Verificar se o arquivo existe
if (!$arquivo) {
    set_flash_message('danger', 'Arquivo não encontrado.');
    redirect('/arquivos.php');
}

// Verificar permissão de acesso
$permitido = false;

if ($arquivo['usuario_id'] == $user_id) {
    // É o proprietário
    $permitido = true;
} elseif ($arquivo['visibilidade'] == 'publico') {
    // Arquivo público
    $permitido = true;
} elseif ($arquivo['franquia_id']) {
    // Verificar se o usuário pertence à franquia do arquivo
    $franquias_usuario = $usuario->getFranquias($user_id);
    $franquia_ids = array_column($franquias_usuario, 'id');
    
    if (in_array($arquivo['franquia_id'], $franquia_ids)) {
        $permitido = true;
    }
} elseif (is_admin()) {
    // Administrador tem acesso a tudo
    $permitido = true;
}

if (!$permitido) {
    set_flash_message('danger', 'Você não tem permissão para visualizar este arquivo.');
    redirect('/arquivos.php');
}

// Obter informações do proprietário
$proprietario = $arquivo['usuario_id'] ? $usuario->getById($arquivo['usuario_id']) : null;

// Obter informações da franquia
$franquia_info = $arquivo['franquia_id'] ? $franquia->getById($arquivo['franquia_id']) : null;

// Iniciar buffer de saída para capturar o conteúdo
ob_start();
?>

<div class="container-fluid">
    <!-- Barra de navegação -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/arquivos.php">Meus Arquivos</a></li>
            <li class="breadcrumb-item active">Visualizar Arquivo</li>
        </ol>
    </nav>
    
    <div class="row">
        <div class="col-lg-8">
            <!-- Visualizador de arquivo -->
            <div class="card shadow mb-4">
                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <?php echo htmlspecialchars($arquivo['nome']); ?>
                        <small class="ms-2 badge bg-secondary"><?php echo strtoupper($arquivo['tipo']); ?></small>
                    </h5>
                    <div>
                        <a href="/uploads/<?php echo htmlspecialchars($arquivo['caminho']); ?>" class="btn btn-primary btn-sm" download>
                            <i class="fas fa-download me-1"></i> Download
                        </a>
                        
                        <?php if ($arquivo['usuario_id'] == $user_id || is_admin()): ?>
                        <a href="/arquivos.php?excluir_arquivo=<?php echo $arquivo['id']; ?>" class="btn btn-danger btn-sm" 
                           onclick="return confirm('Tem certeza que deseja excluir este arquivo?');">
                            <i class="fas fa-trash me-1"></i> Excluir
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body text-center">
                    <?php
                    // Visualização depende do tipo do arquivo
                    $caminho_arquivo = '/uploads/' . htmlspecialchars($arquivo['caminho']);
                    $tipo_arquivo = strtolower($arquivo['tipo']);
                    
                    if ($arquivo['categoria'] == 'imagem'):
                    ?>
                    <img src="<?php echo $caminho_arquivo; ?>" class="img-fluid" alt="<?php echo htmlspecialchars($arquivo['nome']); ?>" style="max-height: 70vh;">
                    <?php elseif ($arquivo['categoria'] == 'video'): ?>
                    <video controls class="w-100" style="max-height: 70vh;">
                        <source src="<?php echo $caminho_arquivo; ?>" type="video/<?php echo ($tipo_arquivo == 'mp4') ? 'mp4' : 'webm'; ?>">
                        Seu navegador não suporta a reprodução deste vídeo.
                    </video>
                    <?php elseif ($tipo_arquivo == 'pdf'): ?>
                    <div class="ratio ratio-16x9" style="height: 70vh;">
                        <iframe src="<?php echo $caminho_arquivo; ?>" allowfullscreen></iframe>
                    </div>
                    <?php else: ?>
                    <div class="p-5 border rounded bg-light">
                        <i class="fas fa-file-alt fa-5x text-muted mb-3"></i>
                        <p class="mb-3">Este tipo de arquivo não pode ser visualizado diretamente no navegador.</p>
                        <a href="<?php echo $caminho_arquivo; ?>" class="btn btn-primary" download>
                            <i class="fas fa-download me-2"></i> Baixar Arquivo
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Detalhes do arquivo -->
            <div class="card shadow mb-4">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Detalhes do Arquivo</h5>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <th scope="row" width="35%">Nome</th>
                                <td><?php echo htmlspecialchars($arquivo['nome']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Tipo</th>
                                <td><?php echo strtoupper($arquivo['tipo']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Tamanho</th>
                                <td><?php echo format_file_size($arquivo['tamanho']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Categoria</th>
                                <td>
                                    <?php
                                    $categoria_label = '';
                                    switch($arquivo['categoria']) {
                                        case 'documento': $categoria_label = '<span class="badge bg-primary">Documento</span>'; break;
                                        case 'imagem': $categoria_label = '<span class="badge bg-success">Imagem</span>'; break;
                                        case 'video': $categoria_label = '<span class="badge bg-info">Vídeo</span>'; break;
                                    }
                                    echo $categoria_label;
                                    ?>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row">Data de Upload</th>
                                <td><?php echo format_date($arquivo['created_at'], 'd/m/Y H:i'); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Proprietário</th>
                                <td>
                                    <?php if ($arquivo['usuario_id'] == $user_id): ?>
                                    <span class="text-primary">Você</span>
                                    <?php elseif ($proprietario): ?>
                                    <?php echo htmlspecialchars($proprietario['nome']); ?>
                                    <?php else: ?>
                                    <em>Desconhecido</em>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php if ($franquia_info): ?>
                            <tr>
                                <th scope="row">Franquia</th>
                                <td><?php echo htmlspecialchars($franquia_info['nome']); ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <th scope="row">Visibilidade</th>
                                <td>
                                    <?php if ($arquivo['visibilidade'] == 'publico'): ?>
                                    <span class="badge bg-success">Público</span>
                                    <?php else: ?>
                                    <span class="badge bg-secondary">Privado</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer bg-white">
                    <a href="/arquivos.php" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i> Voltar
                    </a>
                    <a href="<?php echo $caminho_arquivo; ?>" class="btn btn-primary btn-sm" download>
                        <i class="fas fa-download me-1"></i> Download
                    </a>
                </div>
            </div>
            
            <?php if ($arquivo['usuario_id'] == $user_id || is_admin()): ?>
            <!-- Ações para o proprietário ou admin -->
            <div class="card shadow mb-4">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Ações</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editarArquivoModal">
                            <i class="fas fa-edit me-2"></i> Editar Informações
                        </button>
                        <a href="/arquivos.php?excluir_arquivo=<?php echo $arquivo['id']; ?>" class="btn btn-outline-danger" 
                           onclick="return confirm('Tem certeza que deseja excluir este arquivo?');">
                            <i class="fas fa-trash me-2"></i> Excluir Arquivo
                        </a>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php if ($arquivo['usuario_id'] == $user_id || is_admin()): ?>
<!-- Modal para editar informações do arquivo -->
<div class="modal fade" id="editarArquivoModal" tabindex="-1" aria-labelledby="editarArquivoModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="/arquivos.php" method="post">
                <input type="hidden" name="action" value="editar_arquivo">
                <input type="hidden" name="arquivo_id" value="<?php echo $arquivo['id']; ?>">
                
                <div class="modal-header">
                    <h5 class="modal-title" id="editarArquivoModalLabel">Editar Informações do Arquivo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome do Arquivo</label>
                        <input type="text" class="form-control" id="nome" name="nome" value="<?php echo htmlspecialchars($arquivo['nome']); ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="visibilidade" class="form-label">Visibilidade</label>
                        <select class="form-select" id="visibilidade" name="visibilidade">
                            <option value="privado" <?php echo $arquivo['visibilidade'] == 'privado' ? 'selected' : ''; ?>>Privado (apenas você)</option>
                            <option value="publico" <?php echo $arquivo['visibilidade'] == 'publico' ? 'selected' : ''; ?>>Público (todos da franquia)</option>
                        </select>
                    </div>
                    
                    <?php if (!empty($franquias_usuario)): ?>
                    <div class="mb-3">
                        <label for="franquia_id" class="form-label">Franquia (opcional)</label>
                        <select class="form-select" id="franquia_id" name="franquia_id">
                            <option value="">Pessoal (nenhuma franquia)</option>
                            <?php foreach ($franquias_usuario as $fr): ?>
                            <option value="<?php echo $fr['id']; ?>" <?php echo $arquivo['franquia_id'] == $fr['id'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($fr['nome']); ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                        <div class="form-text">Se escolher uma franquia, o arquivo será compartilhado com todos os usuários da franquia.</div>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<?php
// Capturar o conteúdo e armazenar na variável
$conteudo = ob_get_clean();

// Incluir o layout principal
include_once APP_PATH . '/views/layout.php';
?> 