<?php
/**
 * Página de listagem de arquivos
 */

$titulo_pagina = isset($titulo_listagem) ? $titulo_listagem : 'Meus Arquivos';

// Iniciar buffer de saída para capturar o conteúdo
ob_start();
?>

<div class="container-fluid">
    <!-- Cabeçalho da página -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800"><?php echo $titulo_pagina; ?></h1>
        <div>
            <a href="/arquivos.php?view=upload<?php echo isset($franquia_id) ? '&franquia=' . $franquia_id : ''; ?>" class="btn btn-primary">
                <i class="fas fa-upload me-2"></i> Upload de Arquivos
            </a>
        </div>
    </div>
    
    <!-- Filtros e navegação -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">Arquivos</h6>
            <div class="dropdown">
                <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" 
                        data-bs-toggle="dropdown" aria-expanded="false">
                    Filtrar por
                </button>
                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton">
                    <li><a class="dropdown-item" href="/arquivos.php">Meus Arquivos</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <?php if (!empty($franquias_usuario)): ?>
                        <li><h6 class="dropdown-header">Franquias</h6></li>
                        <?php foreach ($franquias_usuario as $fr): ?>
                        <li>
                            <a class="dropdown-item" href="/arquivos.php?franquia=<?php echo $fr['id']; ?>">
                                <?php echo htmlspecialchars($fr['nome']); ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
        <div class="card-body">
            <!-- Navegação de pastas -->
            <?php if (!empty($pasta_atual)): ?>
            <nav aria-label="breadcrumb" class="mb-3">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/arquivos.php<?php echo isset($franquia_id) ? '?franquia=' . $franquia_id : ''; ?>">
                            <i class="fas fa-home"></i> Raiz
                        </a>
                    </li>
                    <?php
                    $pasta_partes = explode('/', $pasta_atual);
                    $pasta_caminho = '';
                    foreach ($pasta_partes as $index => $parte) {
                        $pasta_caminho .= $parte;
                        if ($index < count($pasta_partes) - 1) {
                            echo '<li class="breadcrumb-item"><a href="/arquivos.php?pasta=' . $pasta_caminho . 
                                 (isset($franquia_id) ? '&franquia=' . $franquia_id : '') . '">' . 
                                 htmlspecialchars($parte) . '</a></li>';
                            $pasta_caminho .= '/';
                        } else {
                            echo '<li class="breadcrumb-item active" aria-current="page">' . htmlspecialchars($parte) . '</li>';
                        }
                    }
                    ?>
                </ol>
            </nav>
            <?php endif; ?>
            
            <?php if (empty($arquivos)): ?>
            <!-- Mensagem de pasta vazia -->
            <div class="text-center py-5">
                <i class="fas fa-folder-open fa-4x text-muted mb-3"></i>
                <h5 class="text-muted">Nenhum arquivo encontrado nesta pasta</h5>
                <p class="text-muted">Faça upload de arquivos para começar</p>
                <a href="/arquivos.php?view=upload<?php echo isset($franquia_id) ? '&franquia=' . $franquia_id : ''; ?><?php echo isset($pasta_atual) ? '&pasta=' . urlencode($pasta_atual) : ''; ?>" class="btn btn-primary mt-3">
                    <i class="fas fa-upload me-2"></i> Upload de Arquivos
                </a>
            </div>
            <?php else: ?>
            <!-- Lista de arquivos -->
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th scope="col" width="5%"></th>
                            <th scope="col" width="40%">Nome</th>
                            <th scope="col" width="15%">Tipo</th>
                            <th scope="col" width="15%">Tamanho</th>
                            <th scope="col" width="15%">Data</th>
                            <th scope="col" width="10%">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Primeiro listar pastas
                        $pastas = [];
                        foreach ($arquivos as $arquivo) {
                            if (!empty($arquivo['pasta']) && !in_array($arquivo['pasta'], $pastas)) {
                                $pastas[] = $arquivo['pasta'];
                            }
                        }
                        
                        // Ordenar pastas alfabeticamente
                        sort($pastas);
                        
                        // Exibir pastas
                        foreach ($pastas as $pasta):
                            $caminho_pasta = $pasta_atual ? $pasta_atual . '/' . $pasta : $pasta;
                        ?>
                        <tr>
                            <td><i class="fas fa-folder text-warning fa-lg"></i></td>
                            <td>
                                <a href="/arquivos.php?pasta=<?php echo urlencode($caminho_pasta); ?><?php echo isset($franquia_id) ? '&franquia=' . $franquia_id : ''; ?>" class="text-decoration-none">
                                    <?php echo htmlspecialchars($pasta); ?>
                                </a>
                            </td>
                            <td>Pasta</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                        </tr>
                        <?php endforeach; ?>
                        
                        <?php
                        // Depois listar arquivos (filtrar apenas arquivos sem pasta ou da pasta atual)
                        $arquivos_filtrados = array_filter($arquivos, function($a) use ($pasta_atual) {
                            return empty($a['pasta']) || $a['pasta'] == $pasta_atual;
                        });
                        
                        // Ordenar arquivos por data de criação decrescente
                        usort($arquivos_filtrados, function($a, $b) {
                            return strtotime($b['created_at']) - strtotime($a['created_at']);
                        });
                        
                        foreach ($arquivos_filtrados as $arquivo):
                            // Determinar o ícone baseado no tipo do arquivo
                            $icone = 'fa-file-alt';
                            $cor_icone = 'text-primary';
                            
                            switch ($arquivo['categoria']) {
                                case 'imagem':
                                    $icone = 'fa-file-image';
                                    $cor_icone = 'text-info';
                                    break;
                                case 'video':
                                    $icone = 'fa-file-video';
                                    $cor_icone = 'text-danger';
                                    break;
                                case 'documento':
                                    if ($arquivo['tipo'] == 'pdf') {
                                        $icone = 'fa-file-pdf';
                                        $cor_icone = 'text-danger';
                                    } elseif (in_array($arquivo['tipo'], ['doc', 'docx'])) {
                                        $icone = 'fa-file-word';
                                        $cor_icone = 'text-primary';
                                    } elseif (in_array($arquivo['tipo'], ['xls', 'xlsx'])) {
                                        $icone = 'fa-file-excel';
                                        $cor_icone = 'text-success';
                                    } elseif (in_array($arquivo['tipo'], ['ppt', 'pptx'])) {
                                        $icone = 'fa-file-powerpoint';
                                        $cor_icone = 'text-warning';
                                    }
                                    break;
                            }
                        ?>
                        <tr>
                            <td><i class="fas <?php echo $icone; ?> <?php echo $cor_icone; ?> fa-lg"></i></td>
                            <td>
                                <a href="/arquivos.php?view=visualizar&id=<?php echo $arquivo['id']; ?>" class="text-decoration-none">
                                    <?php echo htmlspecialchars($arquivo['nome']); ?>
                                </a>
                                <?php if ($arquivo['visibilidade'] == 'publico'): ?>
                                <span class="badge bg-success ms-2">Público</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo strtoupper($arquivo['tipo']); ?></td>
                            <td><?php echo format_file_size($arquivo['tamanho']); ?></td>
                            <td><?php echo format_date($arquivo['created_at'], 'd/m/Y H:i'); ?></td>
                            <td>
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" id="dropdownMenuButton<?php echo $arquivo['id']; ?>" data-bs-toggle="dropdown" aria-expanded="false">
                                        Ações
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton<?php echo $arquivo['id']; ?>">
                                        <li>
                                            <a class="dropdown-item" href="/arquivos.php?view=visualizar&id=<?php echo $arquivo['id']; ?>">
                                                <i class="fas fa-eye me-2"></i> Visualizar
                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="/uploads/<?php echo htmlspecialchars($arquivo['caminho']); ?>" download>
                                                <i class="fas fa-download me-2"></i> Download
                                            </a>
                                        </li>
                                        <?php if ($arquivo['usuario_id'] == $user_id || is_admin()): ?>
                                        <li><hr class="dropdown-divider"></li>
                                        <li>
                                            <a class="dropdown-item text-danger" href="/arquivos.php?excluir_arquivo=<?php echo $arquivo['id']; ?>" onclick="return confirm('Tem certeza que deseja excluir este arquivo?');">
                                                <i class="fas fa-trash me-2"></i> Excluir
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
// Capturar o conteúdo e armazenar na variável
$conteudo = ob_get_clean();

// Incluir o layout principal
include_once APP_PATH . '/views/layout.php';
?> 