<?php
/**
 * Página de visualização de arquivos (estilo Google Drive)
 */

$titulo_pagina = 'Meus Arquivos';

// Obter informações do usuário
$user_id = $_SESSION['user_id'];
$user_type = $_SESSION['user_type'];

// Carregar modelos
$usuario = new Usuario();
$franquia = new Franquia();
$arquivo = new Arquivo();
$pasta = new Pasta();

// Obter franquias do usuário
$franquias_usuario = $usuario->getFranquias($user_id);
$franquia_ids = array_column($franquias_usuario, 'id');

// Verificar a pasta atual (se estiver navegando em pastas)
$pasta_atual_id = isset($_GET['pasta']) ? (int)$_GET['pasta'] : null;
$pasta_atual = null;

if ($pasta_atual_id) {
    $pasta_atual = $pasta->getById($pasta_atual_id);
    
    // Verificar se a pasta existe
    if (!$pasta_atual) {
        set_flash_message('danger', 'Pasta não encontrada.');
        redirect('/arquivos.php');
    }
    
    // Verificar permissão de acesso
    $permitido = false;
    
    if ($pasta_atual['usuario_id'] == $user_id) {
        // É o proprietário
        $permitido = true;
    } elseif ($pasta_atual['franquia_id'] && in_array($pasta_atual['franquia_id'], $franquia_ids)) {
        // Pertence a uma franquia do usuário
        $permitido = true;
    } elseif (is_admin()) {
        // Administrador tem acesso a tudo
        $permitido = true;
    }
    
    if (!$permitido) {
        set_flash_message('danger', 'Você não tem permissão para acessar esta pasta.');
        redirect('/arquivos.php');
    }
}

// Construir caminho de navegação (breadcrumb)
$caminho = [];
if ($pasta_atual) {
    $caminho = $pasta->getCaminho($pasta_atual_id);
}

// Obter pastas
$pastas = $pasta->getSubpastas($pasta_atual_id, $user_id);

// Filtrar pastas das franquias do usuário
if (!empty($franquia_ids)) {
    $pastas_franquias = $pasta->getSubpastas($pasta_atual_id, null, $franquia_ids);
    $pastas = array_merge($pastas, $pastas_franquias);
}

// Obter arquivos
if ($pasta_atual_id) {
    $arquivos = $arquivo->getByPasta($pasta_atual_id);
} else {
    $arquivos = $arquivo->getAll($user_id);
    
    // Se for usuário normal, adicionar arquivos das franquias
    if (!empty($franquia_ids)) {
        foreach ($franquia_ids as $fid) {
            $arquivos_franquia = $arquivo->getAll(null, $fid);
            $arquivos = array_merge($arquivos, $arquivos_franquia);
        }
    }
}

// Processar exclusão
if (isset($_GET['excluir_arquivo'])) {
    $id = (int)$_GET['excluir_arquivo'];
    $arq = $arquivo->getById($id);
    
    if ($arq) {
        $pode_excluir = false;
        
        if ($arq['usuario_id'] == $user_id) {
            // É o proprietário
            $pode_excluir = true;
        } elseif (is_admin()) {
            // Administrador pode excluir qualquer arquivo
            $pode_excluir = true;
        }
        
        if ($pode_excluir) {
            if ($arquivo->delete($id)) {
                set_flash_message('success', 'Arquivo excluído com sucesso.');
            } else {
                set_flash_message('danger', 'Erro ao excluir o arquivo.');
            }
        } else {
            set_flash_message('danger', 'Você não tem permissão para excluir este arquivo.');
        }
    } else {
        set_flash_message('danger', 'Arquivo não encontrado.');
    }
    
    // Redirecionar para a mesma pasta
    $redirect_url = '/arquivos.php';
    if ($pasta_atual_id) {
        $redirect_url .= '?pasta=' . $pasta_atual_id;
    }
    redirect($redirect_url);
}

// Processar exclusão de pasta
if (isset($_GET['excluir_pasta'])) {
    $id = (int)$_GET['excluir_pasta'];
    $p = $pasta->getById($id);
    
    if ($p) {
        $pode_excluir = false;
        
        if ($p['usuario_id'] == $user_id) {
            // É o proprietário
            $pode_excluir = true;
        } elseif (is_admin()) {
            // Administrador pode excluir qualquer pasta
            $pode_excluir = true;
        }
        
        if ($pode_excluir) {
            if ($pasta->delete($id)) {
                set_flash_message('success', 'Pasta excluída com sucesso.');
            } else {
                set_flash_message('danger', 'Erro ao excluir a pasta.');
            }
        } else {
            set_flash_message('danger', 'Você não tem permissão para excluir esta pasta.');
        }
    } else {
        set_flash_message('danger', 'Pasta não encontrada.');
    }
    
    // Redirecionar para a pasta pai
    $redirect_url = '/arquivos.php';
    if ($p && $p['pasta_pai_id']) {
        $redirect_url .= '?pasta=' . $p['pasta_pai_id'];
    }
    redirect($redirect_url);
}

// Iniciar buffer de saída para capturar o conteúdo
ob_start();
?>

<div class="container-fluid">
    <!-- Caminho de navegação -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/arquivos.php"><i class="fas fa-home"></i> Meus Arquivos</a>
            </li>
            <?php 
            $num_pastas = count($caminho);
            foreach ($caminho as $i => $p): 
                $is_last = ($i == $num_pastas - 1);
            ?>
            <li class="breadcrumb-item <?php echo $is_last ? 'active' : ''; ?>">
                <?php if ($is_last): ?>
                <?php echo htmlspecialchars($p['nome']); ?>
                <?php else: ?>
                <a href="/arquivos.php?pasta=<?php echo $p['id']; ?>"><?php echo htmlspecialchars($p['nome']); ?></a>
                <?php endif; ?>
            </li>
            <?php endforeach; ?>
        </ol>
    </nav>
    
    <!-- Ações -->
    <div class="d-flex justify-content-between mb-4">
        <div>
            <div class="btn-group">
                <a href="/arquivos/upload.php<?php echo $pasta_atual_id ? '?pasta=' . $pasta_atual_id : ''; ?>" class="btn btn-primary">
                    <i class="fas fa-upload me-2"></i> Enviar Arquivo
                </a>
                
                <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#novaPastaModal">
                    <i class="fas fa-folder-plus me-2"></i> Nova Pasta
                </button>
            </div>
        </div>
        
        <div>
            <div class="input-group">
                <input type="text" class="form-control" id="busca-arquivos" placeholder="Buscar arquivos...">
                <button class="btn btn-outline-secondary" type="button" id="btn-buscar">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </div>
    </div>
    
    <!-- Pastas -->
    <?php if (!empty($pastas)): ?>
    <div class="card mb-4">
        <div class="card-header bg-light">
            <h6 class="m-0"><i class="fas fa-folder me-2"></i> Pastas</h6>
        </div>
        <div class="card-body">
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-4 g-4">
                <?php foreach ($pastas as $p): ?>
                <div class="col">
                    <div class="card h-100 pasta-card">
                        <div class="card-body d-flex align-items-center">
                            <div class="folder-icon me-3">
                                <i class="fas fa-folder fa-3x text-warning"></i>
                            </div>
                            <div class="folder-info">
                                <h6 class="card-title mb-1"><?php echo htmlspecialchars($p['nome']); ?></h6>
                                <p class="card-text">
                                    <small class="text-muted">
                                        <?php 
                                        $contagem = $pasta->contarArquivos($p['id']);
                                        echo $contagem . ' ' . ($contagem == 1 ? 'arquivo' : 'arquivos');
                                        ?>
                                    </small>
                                </p>
                            </div>
                        </div>
                        <div class="card-footer bg-transparent border-top-0">
                            <div class="btn-group btn-group-sm w-100">
                                <a href="/arquivos.php?pasta=<?php echo $p['id']; ?>" class="btn btn-outline-primary">
                                    <i class="fas fa-folder-open"></i> Abrir
                                </a>
                                <?php if ($p['usuario_id'] == $user_id || is_admin()): ?>
                                <button type="button" class="btn btn-outline-danger" 
                                        onclick="confirmarExclusaoPasta(<?php echo $p['id']; ?>, '<?php echo htmlspecialchars(addslashes($p['nome'])); ?>')">
                                    <i class="fas fa-trash"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <!-- Arquivos -->
    <div class="card">
        <div class="card-header bg-light">
            <h6 class="m-0"><i class="fas fa-file me-2"></i> Arquivos</h6>
        </div>
        <div class="card-body">
            <?php if (empty($arquivos)): ?>
            <div class="text-center py-5">
                <i class="fas fa-file-alt fa-3x text-muted mb-3"></i>
                <p class="mb-0">Nenhum arquivo encontrado nesta pasta.</p>
                <p class="text-muted">Clique em "Enviar Arquivo" para adicionar conteúdo.</p>
            </div>
            <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle" id="tabela-arquivos">
                    <thead>
                        <tr>
                            <th width="40%">Nome</th>
                            <th>Tamanho</th>
                            <th>Tipo</th>
                            <th>Data</th>
                            <th>Proprietário</th>
                            <th class="text-end">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($arquivos as $a): ?>
                        <tr>
                            <td>
                                <?php
                                $icone = 'fa-file';
                                switch ($a['categoria']) {
                                    case 'imagem': $icone = 'fa-file-image'; break;
                                    case 'video': $icone = 'fa-file-video'; break;
                                    case 'documento': 
                                        if (in_array($a['tipo'], ['pdf'])) $icone = 'fa-file-pdf';
                                        elseif (in_array($a['tipo'], ['doc', 'docx'])) $icone = 'fa-file-word';
                                        elseif (in_array($a['tipo'], ['xls', 'xlsx'])) $icone = 'fa-file-excel';
                                        elseif (in_array($a['tipo'], ['ppt', 'pptx'])) $icone = 'fa-file-powerpoint';
                                        break;
                                }
                                ?>
                                <i class="fas <?php echo $icone; ?> fa-lg me-2"></i>
                                <a href="/arquivos/visualizar.php?id=<?php echo $a['id']; ?>" class="text-decoration-none">
                                    <?php echo htmlspecialchars($a['nome']); ?>
                                </a>
                            </td>
                            <td><?php echo format_file_size($a['tamanho']); ?></td>
                            <td><span class="badge bg-secondary"><?php echo strtoupper($a['tipo']); ?></span></td>
                            <td><?php echo format_date($a['created_at'], 'd/m/Y H:i'); ?></td>
                            <td>
                                <?php if ($a['usuario_id'] == $user_id): ?>
                                <span class="text-primary">Você</span>
                                <?php elseif (!empty($a['usuario_nome'])): ?>
                                <?php echo htmlspecialchars($a['usuario_nome']); ?>
                                <?php else: ?>
                                <em>Desconhecido</em>
                                <?php endif; ?>
                                
                                <?php if (!empty($a['franquia_nome'])): ?>
                                <br><small class="text-muted"><?php echo htmlspecialchars($a['franquia_nome']); ?></small>
                                <?php endif; ?>
                            </td>
                            <td class="text-end">
                                <div class="btn-group btn-group-sm">
                                    <a href="/arquivos/visualizar.php?id=<?php echo $a['id']; ?>" class="btn btn-outline-info" title="Visualizar">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="/uploads/<?php echo htmlspecialchars($a['caminho']); ?>" class="btn btn-outline-primary" title="Download" download>
                                        <i class="fas fa-download"></i>
                                    </a>
                                    <?php if ($a['usuario_id'] == $user_id || is_admin()): ?>
                                    <button type="button" class="btn btn-outline-danger" 
                                            onclick="confirmarExclusaoArquivo(<?php echo $a['id']; ?>, '<?php echo htmlspecialchars(addslashes($a['nome'])); ?>')" title="Excluir">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal Nova Pasta -->
<div class="modal fade" id="novaPastaModal" tabindex="-1" aria-labelledby="novaPastaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="/pastas/nova.php" method="post">
                <div class="modal-header">
                    <h5 class="modal-title" id="novaPastaModalLabel">Nova Pasta</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
                </div>
                <div class="modal-body">
                    <?php if ($pasta_atual_id): ?>
                    <input type="hidden" name="pasta_pai_id" value="<?php echo $pasta_atual_id; ?>">
                    <?php endif; ?>
                    
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome da Pasta</label>
                        <input type="text" class="form-control" id="nome" name="nome" required>
                    </div>
                    
                    <?php if (!empty($franquias_usuario)): ?>
                    <div class="mb-3">
                        <label for="franquia_id" class="form-label">Franquia (opcional)</label>
                        <select class="form-select" id="franquia_id" name="franquia_id">
                            <option value="">Pessoal (nenhuma franquia)</option>
                            <?php foreach ($franquias_usuario as $fr): ?>
                            <option value="<?php echo $fr['id']; ?>"><?php echo htmlspecialchars($fr['nome']); ?></option>
                            <?php endforeach; ?>
                        </select>
                        <div class="form-text">Se escolher uma franquia, a pasta será compartilhada com todos os usuários da franquia.</div>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Criar Pasta</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    // Função para confirmar exclusão de arquivo
    function confirmarExclusaoArquivo(id, nome) {
        if (confirm(`Tem certeza que deseja excluir o arquivo "${nome}"?\nEsta ação não pode ser desfeita.`)) {
            window.location.href = `/arquivos.php?excluir_arquivo=${id}<?php echo $pasta_atual_id ? '&pasta=' . $pasta_atual_id : ''; ?>`;
        }
    }
    
    // Função para confirmar exclusão de pasta
    function confirmarExclusaoPasta(id, nome) {
        if (confirm(`Tem certeza que deseja excluir a pasta "${nome}" e todo seu conteúdo?\nEsta ação não pode ser desfeita.`)) {
            window.location.href = `/arquivos.php?excluir_pasta=${id}`;
        }
    }
    
    // Busca de arquivos
    document.getElementById('btn-buscar').addEventListener('click', function() {
        const termo = document.getElementById('busca-arquivos').value.toLowerCase();
        const tabela = document.getElementById('tabela-arquivos');
        const linhas = tabela.getElementsByTagName('tbody')[0].getElementsByTagName('tr');
        
        for (let i = 0; i < linhas.length; i++) {
            const nomeTd = linhas[i].getElementsByTagName('td')[0];
            const tipoTd = linhas[i].getElementsByTagName('td')[2];
            
            if (nomeTd) {
                const nomeArquivo = nomeTd.textContent || nomeTd.innerText;
                const tipoArquivo = tipoTd.textContent || tipoTd.innerText;
                
                if (nomeArquivo.toLowerCase().indexOf(termo) > -1 || tipoArquivo.toLowerCase().indexOf(termo) > -1) {
                    linhas[i].style.display = "";
                } else {
                    linhas[i].style.display = "none";
                }
            }
        }
    });
    
    // Permitir busca ao pressionar Enter
    document.getElementById('busca-arquivos').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            document.getElementById('btn-buscar').click();
        }
    });
</script>

<style>
    .pasta-card {
        transition: all 0.2s ease;
        border: 1px solid rgba(0,0,0,.125);
    }
    .pasta-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15);
        border-color: #0d6efd;
    }
    .folder-icon {
        min-width: 50px;
    }
</style>

<?php
// Capturar o conteúdo e armazenar na variável
$conteudo = ob_get_clean();

// Incluir o layout principal
include_once APP_PATH . '/views/layout.php';
?> 