<?php
/**
 * Dashboard principal do sistema
 */

$titulo_pagina = 'Dashboard';

// Verificar se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    redirect('/login.php');
}

// Obter informações do usuário
$user_id = $_SESSION['user_id'];
$user_type = $_SESSION['user_type'];
$user_name = $_SESSION['user_name'];

// Instanciar modelos
$usuario_model = new Usuario();
$franquia_model = new Franquia();
$arquivo_model = new Arquivo();
$notificacao_model = new Notificacao();
$evento_model = new Evento();

// Obter franquias do usuário
$franquias_usuario = $usuario_model->getFranquias($user_id);

// Obter contagem de notificações não lidas
$notificacoes_nao_lidas = $notificacao_model->contarNaoLidas($user_id);

// Obter últimas notificações
$ultimas_notificacoes = $notificacao_model->getByUsuario($user_id, 5, false);

// Obter próximos eventos
$proximos_eventos = $evento_model->getProximos(5, $user_id);

// Obter arquivos recentes
$arquivos_recentes = $arquivo_model->getAll($user_id);
// Limitar a 10 arquivos e ordenar por data de criação
usort($arquivos_recentes, function($a, $b) {
    return strtotime($b['created_at']) - strtotime($a['created_at']);
});
$arquivos_recentes = array_slice($arquivos_recentes, 0, 10);

// Iniciar buffer de saída para capturar o conteúdo
ob_start();
?>

<div class="container-fluid">
    <!-- Cabeçalho da página -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
        <?php if (is_gestor()): ?>
        <a href="/notificacoes/nova.php" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
            <i class="fas fa-bell fa-sm text-white-50 me-1"></i> Nova Notificação
        </a>
        <?php endif; ?>
    </div>

    <!-- Cartões de Estatísticas -->
    <div class="row">
        <!-- Notificações Não Lidas -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Notificações</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $notificacoes_nao_lidas; ?> não lidas</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-bell fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Próximos Eventos -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Próximos Eventos</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo count($proximos_eventos); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Meus Arquivos -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Arquivos Recentes</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo count($arquivos_recentes); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Franquias -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Minhas Franquias</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo count($franquias_usuario); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-store fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Conteúdo da Página -->
    <div class="row">
        <!-- Arquivos Recentes -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Arquivos Recentes</h6>
                    <a href="/arquivos.php" class="btn btn-sm btn-primary">
                        Ver Todos
                    </a>
                </div>
                <div class="card-body">
                    <?php if (empty($arquivos_recentes)): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-file-alt fa-3x text-gray-300 mb-3"></i>
                        <p class="text-muted">Você ainda não possui arquivos.</p>
                        <a href="/arquivos.php?view=upload" class="btn btn-primary">
                            <i class="fas fa-upload me-1"></i> Upload de Arquivos
                        </a>
                    </div>
                    <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="5%"></th>
                                    <th width="40%">Nome</th>
                                    <th width="15%">Tipo</th>
                                    <th width="15%">Tamanho</th>
                                    <th width="15%">Data</th>
                                    <th width="10%"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($arquivos_recentes as $arquivo): 
                                    // Determinar o ícone baseado no tipo do arquivo
                                    $icone = 'fa-file-alt';
                                    $cor_icone = 'text-primary';
                                    
                                    switch ($arquivo['categoria']) {
                                        case 'imagem':
                                            $icone = 'fa-file-image';
                                            $cor_icone = 'text-info';
                                            break;
                                        case 'video':
                                            $icone = 'fa-file-video';
                                            $cor_icone = 'text-danger';
                                            break;
                                        case 'documento':
                                            if ($arquivo['tipo'] == 'pdf') {
                                                $icone = 'fa-file-pdf';
                                                $cor_icone = 'text-danger';
                                            } elseif (in_array($arquivo['tipo'], ['doc', 'docx'])) {
                                                $icone = 'fa-file-word';
                                                $cor_icone = 'text-primary';
                                            } elseif (in_array($arquivo['tipo'], ['xls', 'xlsx'])) {
                                                $icone = 'fa-file-excel';
                                                $cor_icone = 'text-success';
                                            } elseif (in_array($arquivo['tipo'], ['ppt', 'pptx'])) {
                                                $icone = 'fa-file-powerpoint';
                                                $cor_icone = 'text-warning';
                                            }
                                            break;
                                    }
                                ?>
                                <tr>
                                    <td><i class="fas <?php echo $icone; ?> <?php echo $cor_icone; ?>"></i></td>
                                    <td>
                                        <a href="/arquivos.php?view=visualizar&id=<?php echo $arquivo['id']; ?>">
                                            <?php echo htmlspecialchars($arquivo['nome']); ?>
                                        </a>
                                        <?php if ($arquivo['visibilidade'] == 'publico'): ?>
                                        <span class="badge bg-success ms-2">Público</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo strtoupper($arquivo['tipo']); ?></td>
                                    <td><?php echo format_file_size($arquivo['tamanho']); ?></td>
                                    <td><?php echo format_date($arquivo['created_at'], 'd/m/Y H:i'); ?></td>
                                    <td class="text-end">
                                        <a href="/arquivos.php?view=visualizar&id=<?php echo $arquivo['id']; ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Coluna de notificações e eventos -->
        <div class="col-lg-4">
            <!-- Notificações Recentes -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Notificações Recentes</h6>
                    <a href="/notificacoes.php" class="btn btn-sm btn-primary">
                        Ver Todas
                    </a>
                </div>
                <div class="card-body">
                    <?php if (empty($ultimas_notificacoes)): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-bell-slash fa-3x text-gray-300 mb-3"></i>
                        <p class="text-muted">Nenhuma notificação disponível.</p>
                    </div>
                    <?php else: ?>
                    <div class="list-group">
                        <?php foreach ($ultimas_notificacoes as $notificacao): 
                            $tipo_badge = 'bg-primary';
                            switch ($notificacao['tipo']) {
                                case 'success': $tipo_badge = 'bg-success'; break;
                                case 'warning': $tipo_badge = 'bg-warning'; break;
                                case 'error': $tipo_badge = 'bg-danger'; break;
                                case 'info': $tipo_badge = 'bg-info'; break;
                            }
                        ?>
                        <a href="/notificacoes.php?id=<?php echo $notificacao['id']; ?>" class="list-group-item list-group-item-action <?php echo !$notificacao['lida'] ? 'fw-bold' : ''; ?>">
                            <div class="d-flex w-100 justify-content-between">
                                <h6 class="mb-1">
                                    <span class="badge <?php echo $tipo_badge; ?> me-2"><?php echo ucfirst($notificacao['tipo']); ?></span>
                                    <?php echo htmlspecialchars($notificacao['titulo']); ?>
                                </h6>
                                <small><?php echo format_date($notificacao['created_at'], 'd/m H:i'); ?></small>
                            </div>
                            <small class="text-muted"><?php echo substr(htmlspecialchars($notificacao['mensagem']), 0, 80) . (strlen($notificacao['mensagem']) > 80 ? '...' : ''); ?></small>
                        </a>
                        <?php endforeach; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Próximos Eventos -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Próximos Eventos</h6>
                    <a href="/calendario.php" class="btn btn-sm btn-primary">
                        Calendário
                    </a>
                </div>
                <div class="card-body">
                    <?php if (empty($proximos_eventos)): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-calendar-xmark fa-3x text-gray-300 mb-3"></i>
                        <p class="text-muted">Nenhum evento programado.</p>
                        <?php if (!is_gestor()): ?>
                        <a href="/eventos/novo.php" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Criar Evento
                        </a>
                        <?php endif; ?>
                    </div>
                    <?php else: ?>
                    <div class="list-group">
                        <?php foreach ($proximos_eventos as $evento): ?>
                        <a href="/eventos.php?id=<?php echo $evento['id']; ?>" class="list-group-item list-group-item-action">
                            <div class="d-flex w-100 justify-content-between">
                                <h6 class="mb-1"><?php echo htmlspecialchars($evento['titulo']); ?></h6>
                                <small><?php echo format_date($evento['data_inicio'], 'd/m'); ?></small>
                            </div>
                            <small class="text-muted">
                                <i class="fas fa-clock me-1"></i> <?php echo format_date($evento['data_inicio'], 'H:i'); ?> - <?php echo format_date($evento['data_fim'], 'H:i'); ?>
                                <?php if (!empty($evento['local'])): ?>
                                <br><i class="fas fa-map-marker-alt me-1"></i> <?php echo htmlspecialchars($evento['local']); ?>
                                <?php endif; ?>
                            </small>
                        </a>
                        <?php endforeach; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// Capturar o conteúdo e armazenar na variável
$conteudo = ob_get_clean();

// Incluir o layout principal
include_once APP_PATH . '/views/layout.php';
?> 