<?php
/**
 * Tela de login
 */

// Se já estiver logado, redireciona para o dashboard
if (is_logged_in()) {
    redirect('/dashboard.php');
}

// Processar formulário de login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $senha = $_POST['senha'] ?? '';
    
    if (empty($email) || empty($senha)) {
        set_flash_message('danger', 'Por favor, preencha todos os campos.');
    } else {
        $usuario = new Usuario();
        $user = $usuario->verificarLogin($email, $senha);
        
        if ($user) {
            // Login bem-sucedido
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['nome'];
            $_SESSION['user_email'] = $user['email'];
            $_SESSION['user_type'] = $user['tipo'];
            
            // Registrar notificação de login
            $notificacao = new Notificacao();
            $notificacao->enviarParaUsuario(
                $user['id'], 
                'Login realizado', 
                'Você realizou login no sistema em ' . date('d/m/Y H:i:s'),
                'info'
            );
            
            redirect('/dashboard.php');
        } else {
            set_flash_message('danger', 'E-mail ou senha incorretos.');
        }
    }
}

// Obter mensagem flash
$flash = get_flash_message();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | Sistema de Franqueados</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-container {
            max-width: 400px;
            width: 100%;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }
        .login-logo {
            text-align: center;
            margin-bottom: 20px;
        }
        .login-logo i {
            font-size: 48px;
            color: #0d6efd;
        }
        .login-title {
            text-align: center;
            margin-bottom: 30px;
        }
        .form-floating {
            margin-bottom: 15px;
        }
        .btn-login {
            width: 100%;
            padding: 12px;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-logo">
            <i class="fas fa-store"></i>
        </div>
        <div class="login-title">
            <h3>Sistema de Franqueados</h3>
            <p class="text-muted">Entre com suas credenciais</p>
        </div>
        
        <?php if ($flash): ?>
        <div class="alert alert-<?php echo $flash['type']; ?> alert-dismissible fade show" role="alert">
            <?php echo $flash['message']; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Fechar"></button>
        </div>
        <?php endif; ?>
        
        <form method="post" action="">
            <div class="form-floating">
                <input type="email" class="form-control" id="email" name="email" placeholder="nome@exemplo.com" required>
                <label for="email">E-mail</label>
            </div>
            <div class="form-floating">
                <input type="password" class="form-control" id="senha" name="senha" placeholder="Senha" required>
                <label for="senha">Senha</label>
            </div>
            <button type="submit" class="btn btn-primary btn-login">Entrar</button>
        </form>
        
        <div class="mt-4 text-center">
            <small class="text-muted">
                © <?php echo date('Y'); ?> Sistema de Franqueados
            </small>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 