/**
 * Formata o tamanho do arquivo para exibição amigável
 * 
 * @param int $bytes Tamanho em bytes
 * @return string Tamanho formatado (ex: 1.5 MB)
 */
function format_file_size($bytes) {
    if ($bytes >= 1073741824) {
        return number_format($bytes / 1073741824, 2) . ' GB';
    } else if ($bytes >= 1048576) {
        return number_format($bytes / 1048576, 2) . ' MB';
    } else if ($bytes >= 1024) {
        return number_format($bytes / 1024, 2) . ' KB';
    } else {
        return $bytes . ' bytes';
    }
}

/**
 * Verifica se o usuário atual é um administrador
 * 
 * @return bool
 */
function is_admin() {
    return isset($_SESSION['user_type']) && $_SESSION['user_type'] === 'admin';
} 