<?php
/**
 * API para obter eventos para o calendário
 */

// Verificar se o usuário está logado
if (!is_logged_in()) {
    http_response_code(401);
    exit(json_encode(['error' => 'Não autorizado']));
}

// Obter ID do usuário logado
$user_id = $_SESSION['user_id'];

// Obter parâmetros da solicitação
$start = $_GET['start'] ?? null;
$end = $_GET['end'] ?? null;

// Se não foram fornecidos, usar intervalo padrão
if (!$start || !$end) {
    $start = date('Y-m-d', strtotime('-1 month'));
    $end = date('Y-m-d', strtotime('+2 month'));
}

// Obter eventos no período
$evento = new Evento();
$eventos = $evento->getByPeriodo($start, $end, $user_id);

// Formatar eventos para o calendário
$eventos_formatados = $evento->formatarParaCalendario($eventos);

// Definir cabeçalho de resposta como JSON
header('Content-Type: application/json');

// Retornar resposta
echo json_encode($eventos_formatados); 