<?php
/**
 * API para processar upload de arquivos via AJAX
 */

// Verificar se o usuário está logado
if (!is_logged_in()) {
    http_response_code(401);
    exit(json_encode(['success' => false, 'message' => 'Não autorizado']));
}

// Verificar método da requisição
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit(json_encode(['success' => false, 'message' => 'Método não permitido']));
}

// Obter ID do usuário logado
$user_id = $_SESSION['user_id'];

// Verificar se um arquivo foi enviado
if (empty($_FILES['arquivo'])) {
    http_response_code(400);
    exit(json_encode(['success' => false, 'message' => 'Nenhum arquivo enviado']));
}

// Obter dados adicionais
$visibilidade = $_POST['visibilidade'] ?? 'privado';
$franquia_id = !empty($_POST['franquia_id']) ? (int)$_POST['franquia_id'] : null;
$pasta_id = !empty($_POST['pasta_id']) ? (int)$_POST['pasta_id'] : null;

// Validar franquia (se informada)
if ($franquia_id) {
    $franquia = new Franquia();
    if (!$franquia->exists($franquia_id)) {
        http_response_code(400);
        exit(json_encode(['success' => false, 'message' => 'Franquia inválida']));
    }
}

// Validar pasta (se informada)
if ($pasta_id) {
    $pasta = new Pasta();
    if (!$pasta->exists($pasta_id)) {
        http_response_code(400);
        exit(json_encode(['success' => false, 'message' => 'Pasta inválida']));
    }
}

// Processar o upload
$arquivo = new Arquivo();
$resultado = $arquivo->processarUpload($_FILES['arquivo'], [
    'usuario_id' => $user_id,
    'franquia_id' => $franquia_id,
    'pasta_id' => $pasta_id,
    'visibilidade' => $visibilidade
]);

// Definir cabeçalho de resposta como JSON
header('Content-Type: application/json');

// Retornar resposta
echo json_encode($resultado); 